/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.ability;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.ability.Ability;
import com.eeeab.eeeabsmobs.sever.ability.AbilityType;
import com.eeeab.eeeabsmobs.sever.ability.abilities.GuardianLaserAbility;
import com.eeeab.eeeabsmobs.sever.ability.abilities.ImmortalStaffAbility;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.message.MessagePlayerUseAbility;
import com.eeeab.eeeabsmobs.sever.message.MessageUseAbility;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public enum AbilityHandler {
    INSTANCE;

    public static final AbilityType<Player, ImmortalStaffAbility> IMMORTAL_STAFF_ABILITY_TYPE;
    public static final AbilityType<Player, GuardianLaserAbility> GUARDIAN_LASER_ABILITY_TYPE;
    public static final AbilityType<Player, ? extends Ability<?>>[] PLAYER_ABILITY_TYPES;

    public AbilityCapability.IAbilityCapability getAbilityCapability(LivingEntity entity) {
        return HandlerCapability.getCapability((Entity)entity, HandlerCapability.CUSTOM_ABILITY_CAPABILITY);
    }

    public Ability<?> getAbility(Player player, AbilityType<?, ?> abilityType) {
        AbilityCapability.IAbilityCapability capability = this.getAbilityCapability((LivingEntity)player);
        if (capability != null) {
            return capability.getAbilitiesMap().get(abilityType);
        }
        return null;
    }

    public <T extends LivingEntity> void sendAbilityMessage(T entity, AbilityType<?, ?> abilityType) {
        Ability<?> instance;
        if (entity.f_19853_.f_46443_) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null && (instance = abilityCapability.getAbilitiesMap().get(abilityType)).canUse()) {
            abilityCapability.onActive(entity, abilityType);
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageUseAbility(entity, ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypeByEntity(entity), abilityType)));
        }
    }

    public <T extends Player> void sendPlayerAbilityMessage(T entity, AbilityType<?, ?> ability) {
        if (!entity.f_19853_.f_46443_ || !(entity instanceof LocalPlayer)) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability((LivingEntity)entity);
        if (abilityCapability != null) {
            EEEABMobs.NETWORK.sendToServer((Object)new MessagePlayerUseAbility(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypeByEntity((LivingEntity)entity), ability)));
        }
    }

    static {
        IMMORTAL_STAFF_ABILITY_TYPE = new AbilityType<Player, ImmortalStaffAbility>(ImmortalStaffAbility::new, "immortal_staff_ability");
        GUARDIAN_LASER_ABILITY_TYPE = new AbilityType<Player, GuardianLaserAbility>(GuardianLaserAbility::new, "guardian_laser_ability");
        PLAYER_ABILITY_TYPES = new AbilityType[]{IMMORTAL_STAFF_ABILITY_TYPE, GUARDIAN_LASER_ABILITY_TYPE};
    }
}

